// Copyright (c) Microsoft Corporation. All rights reserved.

function OnFinish(selProj, selObj)
{
	try
	{
		wizard.AddSymbol("SAFE_PROJECT_HELP_FILE_NAME", CreateSafeName(wizard.FindSymbol("PROJECT_NAME")));
		wizard.AddSymbol("RC2_FILE_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
		wizard.AddSymbol("RC_FILE_NAME",CreateSafeRCFileName(wizard.FindSymbol("PROJECT_NAME")) + ".rc");

		if(wizard.FindSymbol("AUTOMATION"))
			wizard.AddSymbol("SAFE_IDL_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
		var bOLEDB = wizard.FindSymbol("OLEDB");
		if (bOLEDB)
		{
			var strRowsetClass = wizard.FindSymbol("ROWSET_CLASS");
			var bAttributed = wizard.FindSymbol("ATTRIBUTED");
			var strCode = wizard.GetConsumerClass(strRowsetClass, bAttributed);
			wizard.AddSymbol("ROWSET_CLASS_CODE", strCode);
		}
		else
		{
			var bODBC = wizard.FindSymbol("ODBC");
			if (bODBC)
			{
				var strRowsetClass = wizard.FindSymbol("ROWSET_CLASS");
				var bSnapshot = wizard.FindSymbol("SNAPSHOT");
				var bBindAllColumns = wizard.FindSymbol("BIND_ALL_COLUMNS");
				var strCodeDecl = wizard.GetODBCConsumerClassDecl(bBindAllColumns, bSnapshot, strRowsetClass);
				var strCodeImpl = wizard.GetODBCConsumerClassImpl();
				wizard.AddSymbol("ROWSET_CLASS_ODBC_DECL", strCodeDecl);
				wizard.AddSymbol("ROWSET_CLASS_ODBC_IMPL", strCodeImpl);
			}
		}

		var strProjectPath = wizard.FindSymbol("PROJECT_PATH");
		var strProjectName = wizard.FindSymbol("PROJECT_NAME");

		selProj = CreateProject(strProjectName, strProjectPath);

		AddCommonConfig(selProj, strProjectName, /*unicode*/ true);
		AddSpecificConfig(selProj, strProjectName, strProjectPath);

		SetupFilters(selProj);

		var strDocTypeName = wizard.FindSymbol("DOC_TYPE_NAME");
		if (strDocTypeName != "" )
		{
			wizard.AddSymbol("SAFE_DOC_TYPE_NAME", CreateSafeName(strDocTypeName));
		}

		selProj.Object.keyword = "MFCProj";

		SetResDlgFont();

		AddFilesToProjectWithInfFile(selProj, strProjectName);
		SetCommonPchSettings(selProj);

		var Sdl = wizard.FindSymbol("SDL_CHECK");

		if (Sdl)
		{
			EnableSDLCheckSettings(selProj);
		}

		selProj.Object.Save();

		if (wizard.FindSymbol("APP_TYPE_DLG"))
		{
			var strDialogId = "IDD_" + wizard.FindSymbol("UPPER_CASE_SAFE_PROJECT_IDENTIFIER_NAME") + "_DIALOG";
			var oResHelper = wizard.ResourceHelper;
			oResHelper.OpenResourceFile(strProjectPath + "\\" + strProjectName + ".rc");
			oResHelper.OpenResourceInEditor("Dialog", strDialogId);
		}

		SetAllConfigCharset(selProj, /*unicode*/ true);

		// Create ATL project with preview/search/thumbnail handlers if requested
		if (wizard.FindSymbol("PREVIEW_HANDLER") || wizard.FindSymbol("SEARCH_HANDLER") || wizard.FindSymbol("THUMBNAIL_HANDLER"))
		{
			var strATLProjectName = strProjectName + "Handlers";
			var strATLProjectNameSafe = CreateASCIIName(strATLProjectName);
			wizard.AddSymbol("CLOSE_SOLUTION", false);
			oFSO = new ActiveXObject("Scripting.FileSystemObject");
			strATLProjectPath = oFSO.GetAbsolutePathName(strProjectPath + "\\..\\" + strATLProjectName);
			var strBaseProjectName = wizard.FindSymbol("PROJECT_NAME");
			wizard.AddSymbol("BASE_PROJECT_NAME", strBaseProjectName);
			wizard.AddSymbol("PROJECT_NAME", strATLProjectName);
			wizard.AddSymbol("PROJECT_PATH", strATLProjectPath);
			wizard.AddSymbol("LIB_NAME", strATLProjectName);
			wizard.AddSymbol("UPPER_CASE_SAFE_PROJECT_IDENTIFIER_NAME", (CreateSafeName(strATLProjectName)).toUpperCase());
			wizard.AddSymbol("SAFE_IDL_NAME", strATLProjectNameSafe);
			wizard.AddSymbol("SAFE_ATL_MODULE_NAME", CreateClassName(strATLProjectNameSafe, "Module"));
			wizard.AddSymbol("SAFE_MFC_APP_NAME", CreateClassName(strATLProjectNameSafe, "App"));
			CreateGuids();

			var oATLProj = CreateProject(strATLProjectName, strATLProjectPath);
			StampWindowsTargetPlatformVersion(oATLProj);
			SetupFilters(oATLProj);
			oATLProj.Object.keyword = "AtlProj";
			AddFilesToProjectWithNamedInfFile(oATLProj, strATLProjectName, "Handler_Templates.inf");

			SetCommonPchSettings(oATLProj);
			SetATLConfigsType(oATLProj, typeDynamicLibrary);
			SetAllConfigCharset(oATLProj, true);
			SetATLConfigsToolSettings(oATLProj, strATLProjectName);
			SetATLConfigsMFC(oATLProj);
			SetFileSettings(oATLProj);

			var strMFCDocHeader = "..\\" + strBaseProjectName + "\\" + wizard.FindSymbol("DOC_HEADER");
			if (oATLProj.Object.CanAddFile(strMFCDocHeader))
			{
				oATLProj.Object.AddFile(strMFCDocHeader);
			}
			var strMFCDocImpl = "..\\" + strBaseProjectName + "\\" + wizard.FindSymbol("DOC_IMPL");
			if (oATLProj.Object.CanAddFile(strMFCDocImpl))
			{
				oATLProj.Object.AddFile(strMFCDocImpl);
			}

			if (wizard.FindSymbol("PREVIEW_HANDLER"))
			{
				var strMFCViewHeader = "..\\" + strBaseProjectName + "\\" + wizard.FindSymbol("VIEW_HEADER");
				if (oATLProj.Object.CanAddFile(strMFCViewHeader))
				{
					oATLProj.Object.AddFile(strMFCViewHeader);
				}
				var strMFCViewImpl = "..\\" + strBaseProjectName + "\\" + wizard.FindSymbol("VIEW_IMPL");
				if (oATLProj.Object.CanAddFile(strMFCViewImpl))
				{
					oATLProj.Object.AddFile(strMFCViewImpl);
				}
			}

			var strMFCCntrHeader = "..\\" + strBaseProjectName + "\\CntrItem.h";
			strFile = oFSO.GetAbsolutePathName(strATLProjectPath + "\\" + strMFCCntrHeader);
			if (oFSO.FileExists(strFile) && oATLProj.Object.CanAddFile(strMFCCntrHeader)) {
				oATLProj.Object.AddFile(strMFCCntrHeader);

				var strMFCCntrImpl = "..\\" + strBaseProjectName + "\\CntrItem.cpp";
				strFile = oFSO.GetAbsolutePathName(strATLProjectPath + "\\" + strMFCCntrImpl);
				if (oFSO.FileExists(strFile) && oATLProj.Object.CanAddFile(strMFCCntrImpl)) {
					oATLProj.Object.AddFile(strMFCCntrImpl);
				}
			}

			var strMFCSrvrHeader = "..\\" + strBaseProjectName + "\\SrvrItem.h";
			strFile = oFSO.GetAbsolutePathName(strATLProjectPath + "\\" + strMFCSrvrHeader);
			if (oFSO.FileExists(strFile) && oATLProj.Object.CanAddFile(strMFCSrvrHeader)) {
			    oATLProj.Object.AddFile(strMFCSrvrHeader);

			    var strMFCSrvrImpl = "..\\" + strBaseProjectName + "\\SrvrItem.cpp";
			    strFile = oFSO.GetAbsolutePathName(strATLProjectPath + "\\" + strMFCSrvrImpl);
			    if (oFSO.FileExists(strFile) && oATLProj.Object.CanAddFile(strMFCSrvrImpl)) {
			        oATLProj.Object.AddFile(strMFCSrvrImpl);
			    }
			}

			var L_strGenerated_Text = "ɵļ";
			var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
			var oGeneratedFiles = oATLProj.Object.AddFilter(L_strGenerated_Text);
			if (oGeneratedFiles)
			{
				oGeneratedFiles.SourceControlFiles = false;
				var files = oATLProj.Object.Files;
				var file;
				file = files(strIdlName + "_i.c");
				if (file.CanMove(oGeneratedFiles))
					file.Move(oGeneratedFiles);
				file = files(strIdlName + "_i.h");
				if (file.CanMove(oGeneratedFiles))
					file.Move(oGeneratedFiles);
			}

			oATLProj.Object.Save();
		}
	}
	catch(e)
	{
		if (e.description.length != 0)
			SetErrorInfo(e);
		return e.number
	}
}

function CreateGuids()
{
	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("LIBID_REGISTRY_FORMAT", strVal);
	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("CLSID_REGISTRY_FORMAT", strVal);
	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("APPID_REGISTRY_FORMAT", strVal);

	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("CLSID_PREVIEW", strVal);
	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("IID_PREVIEW", strVal);

	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("CLSID_THUMBNAIL", strVal);
	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("IID_THUMBNAIL", strVal);

	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("CLSID_SEARCH", strVal);
	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("IID_SEARCH", strVal);

	strGuid = wizard.CreateGuid();
	strVal = wizard.FormatGuid(strGuid, 0);
	wizard.AddSymbol("CLSID_PERSISTENT_HANDLER", strVal);
}

function SetFileProperties(projfile, strName)
{
	return false;
}

function CreateClassName(strPrefix, strPostfix)
{
	var strCandidate;
	strCandidate = "C" + strPrefix + strPostfix;
	return strCandidate;
}

function SetATLConfigsToolSettings(oProj, strProjectName)
{
	var oConfigs = oProj.Object.Configurations;
	for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
	{
		var config = oConfigs(nCntr);
		var bDebug = false;
		if (-1 != config.Name.indexOf("Debug"))
		{
			bDebug = true;
		}

		// MIDL settings
		var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
		var MidlTool = config.Tools("VCMidlTool");
		MidlTool.MkTypLibCompatible = false;

		if (IsPlatformWin32(config))
			MidlTool.TargetEnvironment = midlTargetWin32;

		if (bDebug)
			MidlTool.PreprocessorDefinitions = "_DEBUG";
		else
			MidlTool.PreprocessorDefinitions = "NDEBUG";

		MidlTool.HeaderFileName = strIdlName + "_i.h";
		MidlTool.InterfaceIdentifierFileName = strIdlName + "_i.c";
		MidlTool.ProxyFileName = strIdlName + "_p.c";
		MidlTool.GenerateStublessProxies = true;
		MidlTool.TypeLibraryName = "$(IntDir)" + strIdlName + ".tlb";
		MidlTool.DLLDataFileName = "";

		// no /no_robust
		MidlTool.ValidateParameters = true;

		// Compiler settings
		var CLTool = config.Tools("VCCLCompilerTool");
		CLTool.UsePrecompiledHeader = pchUseUsingSpecific;
		CLTool.WarningLevel = WarningLevel_3;
		if (bDebug)
		{
			CLTool.Optimization = optimizeDisabled;
			CLTool.PreprocessorDefinitions = "WIN32;_WINDOWS;_DEBUG;_USRDLL";
		}
		else
		{
			CLTool.Optimization = optimizeMaxSpeed;
			CLTool.PreprocessorDefinitions = "WIN32;_WINDOWS;NDEBUG;_USRDLL";
		}

		// Resource settings
		var RCTool = config.Tools("VCResourceCompilerTool");
		RCTool.Culture = wizard.FindSymbol("LCID");
		RCTool.AdditionalIncludeDirectories = "$(IntDir)";
		if (bDebug)
			RCTool.PreprocessorDefinitions = "_DEBUG";
		else
			RCTool.PreprocessorDefinitions = "NDEBUG";

		// Linker settings
		var LinkTool = config.Tools("VCLinkerTool");
		LinkTool.SubSystem = subSystemWindows;
		LinkTool.IgnoreImportLibrary = true;

		var strDefFile = ".\\" + strProjectName + ".def";
		LinkTool.ModuleDefinitionFile = strDefFile;

		if (bDebug)
		{
			LinkTool.LinkIncremental = linkIncrementalYes;
		}
		else
		{
			LinkTool.LinkIncremental = linkIncrementalNo;
			LinkTool.EnableCOMDATFolding = optFolding;
			LinkTool.OptimizeReferences = optReferences;
		}

		LinkTool.RegisterOutput = true;

		// Post-build step to set permissions on the DLL (if necessary)
		if (wizard.FindSymbol("SEARCH_HANDLER"))
		{
			var L_SettingPermissions_Text = "ô DLL Ȩ( SearchFilterHost.exe )...";

			var PostBuildTool = config.Tools("VCPostBuildEventTool");
			PostBuildTool.Description = L_SettingPermissions_Text;

			// Grant Read and Execute right to "Users" group.
			PostBuildTool.CommandLine = "icacls.exe \"$(TargetPath)\" /grant *S-1-5-32-545:RX";
		}
	}
}

function SetATLConfigsType(oProj, typeConfig)
{
	var oConfigs = oProj.Object.Configurations;
	for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
	{
		var config = oConfigs(nCntr);
		config.ConfigurationType = typeConfig;
	}
}

function SetATLConfigsMFC(oProj)
{
	var bDynamicMFC = wizard.FindSymbol("DYNAMIC_MFC");
	var oConfigs = oProj.Object.Configurations;
	for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
	{
		var config = oConfigs(nCntr);
		var bDebug = false;
		if (-1 != config.Name.indexOf("Debug"))
		{
			bDebug = true;
		}

		var CLTool = config.Tools("VCCLCompilerTool");

		if (bDynamicMFC)
		{
			config.UseOfMFC = useMfcDynamic;
		}
		else
		{
			config.UseOfMFC = useMfcStatic;
		}
	}
}

function SetSingleFileSettings(file)
{
	var nCntr;
	for (nCntr = 1; nCntr <= file.FileConfigurations.Count; nCntr++)
	{
		var config = file.FileConfigurations(nCntr);
		config.Tool.CompileAsManaged = 0; // no /CLR
		config.Tool.UsePrecompiledHeader = pchNone; // no PCH
	}
}

function SetFileSettings(proj)
{
	try
	{
		var files = proj.Object.Files;
		var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");

		SetSingleFileSettings(files(strIdlName + "_i.c"));
		SetSingleFileSettings(files("xdlldata.c"));
	}
	catch (e) {
		throw e;
	}
}

function AddSpecificConfig(proj, strProjectName, strProjectPath)
{
	try
	{
		var bAutomation = wizard.FindSymbol("AUTOMATION");
		var bServer = wizard.FindSymbol("MINI_SERVER");
		var bDynamicMFC = wizard.FindSymbol("DYNAMIC_MFC");

		if (!bServer)
		{
			bServer = wizard.FindSymbol("FULL_SERVER");
			if (!bServer)
				bServer = wizard.FindSymbol("CONTAINER_SERVER");
		}
		var oConfigs = proj.Object.Configurations;
		for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
		{
			var config = oConfigs(nCntr);
			var bDebug = false;
			if (-1 != config.Name.indexOf("Debug"))
				bDebug = true;
			// Default to unicode
			config.CharacterSet = charSetUNICODE;

			var CLTool = config.Tools("VCCLCompilerTool");

			if (bDynamicMFC)
			{
				config.UseOfMFC = useMfcDynamic;
			}
			else
			{
				config.UseOfMFC = useMfcStatic;
			}
			var strDefines = CLTool.PreprocessorDefinitions;
			if (strDefines != "") strDefines += ";";
			strDefines += GetPlatformDefine(config);
			if(bDebug)
			{
				strDefines += "_WINDOWS;_DEBUG";
			}
			else
			{
				strDefines += "_WINDOWS;NDEBUG";
			}
			CLTool.PreprocessorDefinitions= strDefines;

			var LinkTool = config.Tools("VCLinkerTool");

			LinkTool.LinkIncremental = (bDebug ? linkIncrementalYes : linkIncrementalNo);

			var bRibbon = wizard.FindSymbol("RIBBON_TOOLBAR");
			var bTabbedMDI = wizard.FindSymbol("APP_TYPE_TABBED_MDI");
			var bDBSupportHeaderOnly = wizard.FindSymbol("DB_SUPPORT_HEADER_ONLY");

			var bOLEDB = wizard.FindSymbol("OLEDB");
			var bSupportOLEDB = wizard.FindSymbol("DB_SUPPORT_OLEDB");
			if (bOLEDB || (bDBSupportHeaderOnly && bSupportOLEDB))
			{
				LinkTool.AdditionalDependencies = "msdasc.lib";
			}

			var bODBC = wizard.FindSymbol("ODBC");
			var bSupportODBC = wizard.FindSymbol("DB_SUPPORT_ODBC");
			if (bODBC || (bDBSupportHeaderOnly && bSupportODBC))
			{
				LinkTool.AdditionalDependencies = "odbc32.lib";
			}

			var MidlTool = config.Tools("VCMidlTool");
			MidlTool.MkTypLibCompatible = false;

			// no /no_robust
			MidlTool.ValidateParameters = true;
			MidlTool.PreprocessorDefinitions = (bDebug ? "_DEBUG" : "NDEBUG");

			if (bAutomation)
			{
				var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
				MidlTool.TypeLibraryName = "$(IntDir)" + strIdlName + ".tlb";
				MidlTool.HeaderFileName = strIdlName + "_h.h";
			}

			var RCTool = config.Tools("VCResourceCompilerTool");
			RCTool.Culture = wizard.FindSymbol("LCID");
			RCTool.PreprocessorDefinitions = (bDebug ? "_DEBUG" : "NDEBUG");
			RCTool.AdditionalIncludeDirectories = "$(IntDir)";

			if (bServer || bAutomation)
			{
				LinkTool.RegisterOutput = true;
			}
		} //for
	}
	catch(e)
	{
		throw e;
	}
}

function GetTargetName(strName, strProjectName, strResPath, strHelpPath)
{
	try
	{
		var strTarget = strName;
		var strSafeProjHelpFileName = wizard.FindSymbol("SAFE_PROJECT_HELP_FILE_NAME");
		var strRC2FileName = wizard.FindSymbol("RC2_FILE_NAME");
		if (strName.substr(0, 4) == "root")
		{
			if (strName == "root.ico" || strName == "root.manifest")
			{
				strTarget = strResPath + "\\" + strProjectName + strName.substr(4);
			}
			else if (strName == "root.rc2")
			{
				strTarget = strResPath + "\\" + strRC2FileName + strName.substr(4);
			}
			else if (strName == "root.hpj" || strName == "root.cnt")
			{
				strTarget = strProjectName + strName.substr(4);
				strTarget = strHelpPath + "\\" + strTarget;
			}
			else if (strName == "root.hhc" ||
				strName == "root.hhk" ||
				strName == "root.hhp")
			{
				strTarget = strSafeProjHelpFileName + strName.substr(4);
				strTarget = strHelpPath + "\\" + strTarget;
			}
			else if (strName == "root.idl")
			{
				var strProjectName = wizard.FindSymbol("SAFE_IDL_NAME");
				strTarget = strProjectName + ".idl";
			}
			else
				strTarget = strProjectName + strName.substr(4);
			return strTarget;
		}
		if (strName.substr(0, 7) == "dlgroot")
		{
			var strExtension = strName.substr(7);

			if (strName == "dlgroot.cnt")
			{
				strTarget = strHelpPath + "\\" + strProjectName + strExtension;
			}
			else if (strName == "dlgroot.hhc")
			{
				strTarget = strHelpPath + "\\" + strSafeProjHelpFileName + strExtension;
			}
			else
			{
				strTarget = strProjectName + strExtension;
			}

			return strTarget;
		}

		switch (strName)
		{
			case "readme.txt":
				strTarget = "ReadMe.txt";
				break;
			case "all.rc":
			case "dlgall.rc":
				strTarget = wizard.FindSymbol("RC_FILE_NAME");
				break;
			case "dlgres.h":
			case "resource.h":
				strTarget = "Resource.h";
				break;
			case "dialog.h":
				strTarget = wizard.FindSymbol("DIALOG_HEADER");
				break;
			case "dialog.cpp":
				strTarget = wizard.FindSymbol("DIALOG_IMPL");
				break;
			case "dlgproxy.h":
				strTarget = wizard.FindSymbol("DIALOG_AUTO_PROXY_HEADER");
				break;
			case "dlgproxy.cpp":
				strTarget = wizard.FindSymbol("DIALOG_AUTO_PROXY_IMPL");
				break;
			case "frame.h":
				strTarget = wizard.FindSymbol("MAIN_FRAME_HEADER");
				break;
			case "frame.cpp":
				strTarget = wizard.FindSymbol("MAIN_FRAME_IMPL");
				break;
			case "childfrm.h":
				strTarget = wizard.FindSymbol("CHILD_FRAME_HEADER");
				break;
			case "childfrm.cpp":
				strTarget = wizard.FindSymbol("CHILD_FRAME_IMPL");
				break;
			case "doc.h":
				strTarget = wizard.FindSymbol("DOC_HEADER");
				break;
			case "doc.cpp":
				strTarget = wizard.FindSymbol("DOC_IMPL");
				break;
			case "view.h":
				strTarget = wizard.FindSymbol("VIEW_HEADER");
				break;
			case "view.cpp":
				strTarget = wizard.FindSymbol("VIEW_IMPL");
				break;
			case "wndview.h":
				strTarget = wizard.FindSymbol("WND_VIEW_HEADER");
				break;
			case "wndview.cpp":
				strTarget = wizard.FindSymbol("WND_VIEW_IMPL");
				break;
			case "treeview.h":
				strTarget = wizard.FindSymbol("TREE_VIEW_HEADER");
				break;
			case "treeview.cpp":
				strTarget = wizard.FindSymbol("TREE_VIEW_IMPL");
				break;
			case "recset.h":
				strTarget = wizard.FindSymbol("ROWSET_HEADER");
				break;
			case "recset.cpp":
				strTarget = wizard.FindSymbol("ROWSET_IMPL");
				break;
			case "srvritem.h":
				strTarget = wizard.FindSymbol("SERVER_ITEM_HEADER");
				break;
			case "srvritem.cpp":
				strTarget = wizard.FindSymbol("SERVER_ITEM_IMPL");
				break;
			case "ipframe.h":
				strTarget = wizard.FindSymbol("INPLACE_FRAME_HEADER");
				break;
			case "ipframe.cpp":
				strTarget = wizard.FindSymbol("INPLACE_FRAME_IMPL");
				break;
			case "cntritem.h":
				strTarget = wizard.FindSymbol("CONTAINER_ITEM_HEADER");
				break;
			case "cntritem.cpp":
				strTarget = wizard.FindSymbol("CONTAINER_ITEM_IMPL");
				break;
			case "viewtree.h":
				strTarget = "ViewTree.h";
				break;
			case "viewtree.cpp":
				strTarget = "ViewTree.cpp";
				break;
			case "classview.h":
				strTarget = "ClassView.h";
				break;
			case "classview.cpp":
				strTarget = "ClassView.cpp";
				break;
			case "fileview.h":
				strTarget = "FileView.h";
				break;
			case "fileview.cpp":
				strTarget = "FileView.cpp";
				break;
			case "outputwnd.h":
				strTarget = "OutputWnd.h";
				break;
			case "outputwnd.cpp":
				strTarget = "OutputWnd.cpp";
				break;
			case "propertieswnd.h":
				strTarget = "PropertiesWnd.h";
				break;
			case "propertieswnd.cpp":
				strTarget = "PropertiesWnd.cpp";
				break;
			case "calendarbar.h":
				strTarget = "CalendarBar.h";
				break;
			case "calendarbar.cpp":
				strTarget = "CalendarBar.cpp";
				break;
			case "userimages.bmp":
				strTarget = "UserImages.bmp";
				break;
			case "doc.ico":
				strTarget = strResPath + "\\" + strProjectName + "Doc.ico";
				break;
			case "file_view.ico":
			case "file_view_hc.ico":
			case "fileview.bmp":
			case "fileview_hc.bmp":
			case "class_view.ico":
			case "class_view_hc.ico":
			case "classview.bmp":
			case "classview_hc.bmp":
			case "output_wnd.ico":
			case "output_wnd_hc.ico":
			case "properties_wnd.ico":
			case "properties_wnd_hc.ico":
			case "properties.bmp":
			case "properties_hc.bmp":
			case "explorer.bmp":
			case "explorer_hc.bmp":
			case "sort.bmp":
			case "sort_hc.bmp":
			case "nav_large.bmp":
			case "nav_large_hc.bmp":
			case "pages.bmp":
			case "pages_hc.bmp":
			case "pages_small.bmp":
			case "pages_small_hc.bmp":
			case "menuimages.bmp":
			case "menuimages_hc.bmp":
			case "info.bmp":
				strTarget = strResPath + "\\" + strTarget;
				break;
			case "handler_stdafx.h":
				strTarget = "stdafx.h";
				break;
			case "handler_stdafx.cpp":
				strTarget = "stdafx.cpp";
				break;
			case "handler_dllmain.h":
				strTarget = "dllmain.h";
				break;
			case "handler_dllmain.cpp":
				strTarget = "dllmain.cpp";
				break;
			case "handler_readme.txt":
				strTarget = "ReadMe.txt";
				break;
			case "handler_resource.h":
				strTarget = "Resource.h";
				break;
			case "handler_root.cpp":
				strTarget = strProjectName + ".cpp";
				break;
			case "handler_root.def":
				strTarget = strProjectName + ".def";
				break;
			case "handler_root.idl":
				strTarget = CreateASCIIName(strProjectName) + ".idl";
				break;
			case "handler_root_i.c":
				strTarget = CreateASCIIName(strProjectName) + "_i.c";
				break;
			case "handler_root_i.h":
				strTarget = CreateASCIIName(strProjectName) + "_i.h";
				break;
			case "handler_root.rc":
				strTarget = strProjectName + ".rc";
				break;
			case "handler_root.rgs":
				strTarget = strProjectName + ".rgs";
				break;
			case "handler_preview.h":
				strTarget = "PreviewHandler.h";
				break;
			case "handler_preview.rgs":
				strTarget = "PreviewHandler.rgs";
				break;
			case "handler_search.h":
				strTarget = "FilterHandler.h";
				break;
			case "handler_search.rgs":
				strTarget = "FilterHandler.rgs";
				break;
			case "handler_thumbnail.h":
				strTarget = "ThumbnailHandler.h";
				break;
			case "handler_thumbnail.rgs":
				strTarget = "ThumbnailHandler.rgs";
				break;
			case "handler_targetver.h":
				strTarget = "targetver.h";
				break;
			case "handler_xdlldata.h":
				strTarget = "xdlldata.h";
				break;
			case "handler_xdlldata.c":
				strTarget = "xdlldata.c";
				break;
			default:
				break;
		}

		var strTemp = GetAdditionalPath(strTarget, strResPath, strHelpPath);


		strTarget = strTemp;
		return strTarget;
	}
	catch(e)
	{
		throw e;
	}
}

function GetAdditionalPath(strName, strResPath, strHelpPath)
{
	try
	{
		var strFullName = strName;
		switch(strName)
		{
			case "buttons.bmp":
			case "filelarge.bmp":
			case "filesmall.bmp":
			case "main.bmp":
			case "writelarge.bmp":
			case "writesmall.bmp":
			case "ribbon.mfcribbon-ms":
				strFullName = strResPath + "\\" + strName;
				break;
			case "tbdh_.bmp":
			case "tbd__.bmp":
			case "tbrh_.bmp":
			case "tbr__.bmp":
			case "tbah_.bmp":
			case "tba__.bmp":
			case "tbedh.bmp":
			case "tbed_.bmp":
			case "tbeah.bmp":
			case "tbea_.bmp":
			case "tbndm.bmp":
			case "tbndmh.bmp":
			case "tbnds.bmp":
			case "tbndsh.bmp":
				strFullName = strResPath + "\\Toolbar.bmp";
				break;
			case "tbah_256.bmp":
			case "tba__256.bmp":
			case "tbdh_256.bmp":
			case "tbd__256.bmp":
			case "tbeah_256.bmp":
			case "tbea_256.bmp":
			case "tbedh_256.bmp":
			case "tbed_256.bmp":
			case "tbrh_256.bmp":
			case "tbr__256.bmp":
			case "tbndmh256.bmp":
			case "tbndm256.bmp":
			case "tbndsh256.bmp":
			case "tbnds256.bmp":
				strFullName = strResPath + "\\Toolbar256.bmp";
				break;
			case "tba_i.bmp":
			case "tbrhi.bmp":
			case "tbr_i.bmp":
			case "tbahi.bmp":
				strFullName = strResPath + "\\IToolbar.bmp";
				break;
			case "tba_i256.bmp":
			case "tbrhi256.bmp":
			case "tbr_i256.bmp":
			case "tbahi256.bmp":
				strFullName = strResPath + "\\IToolbar256.bmp";
				break;
			default:
				break;
		}
		return strFullName;
	}
	catch(e)
	{
		throw e;
	}
}
// SIG // Begin signature block
// SIG // MIIj+wYJKoZIhvcNAQcCoIIj7DCCI+gCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // B8I5jj/DdNVubqsPLFCa0X3+J9lIFLP07Vm3S5ZFue+g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFcAwghW8AgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggawwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIKKjKMQ24EpRkcAO8fluOygh/C8wwyIH4SjxYL2F
// SIG // Ua+rMEAGCisGAQQBgjcCAQwxMjAwoBaAFABkAGUAZgBh
// SIG // AHUAbAB0AC4AagBzoRaAFGh0dHA6Ly9taWNyb3NvZnQu
// SIG // Y29tMA0GCSqGSIb3DQEBAQUABIIBAFKSy39tyoc2/ANW
// SIG // NirCMpW8ON0f90pYhzS9zG0cUvBB5QcJ22uH7leBmQkc
// SIG // vaxRk+EgOQgCkNdHIwarar815n/xRjrub2+ezXOSH+TE
// SIG // uWXhup1yLUlOZp8Sr0vNDF8M8bBopWcVZc2a9R/rHuh5
// SIG // LDu3qqtK3ZY7BOQey0kLJ3o96TPvWDwXAc/ne9eR+kpy
// SIG // +tQVYxgqdoYM2hVlqdSlorie3a+o4nFmX1RSNBTV9lGZ
// SIG // AHzMrYMABcDn4vk2NDUTWZVOHrxWi3F5LQ3yPEqdmvBw
// SIG // 5T3RfcDT5MDAf9t8Uz0Puu7s8phm417MEWE2qoxR0wvx
// SIG // b9KAqR/Qj2/okTOvQCqhghNMMIITSAYKKwYBBAGCNwMD
// SIG // ATGCEzgwghM0BgkqhkiG9w0BBwKgghMlMIITIQIBAzEP
// SIG // MA0GCWCGSAFlAwQCAQUAMIIBPAYLKoZIhvcNAQkQAQSg
// SIG // ggErBIIBJzCCASMCAQEGCisGAQQBhFkKAwEwMTANBglg
// SIG // hkgBZQMEAgEFAAQgXxr5W8CblMJF+WeYPHA04bMyxXCV
// SIG // PhIdyfKUEbkUxHsCBliXjfBKYRgSMjAxNzAyMDkwNDE5
// SIG // NTYuMTRaMAcCAQGAAgH0oIG5pIG2MIGzMQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQL
// SIG // Ex5uQ2lwaGVyIERTRSBFU046NTg0Ny1GNzYxLTRGNzAx
// SIG // JTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNl
// SIG // cnZpY2Wggg7QMIIGcTCCBFmgAwIBAgIKYQmBKgAAAAAA
// SIG // AjANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAwNzAx
// SIG // MjEzNjU1WhcNMjUwNzAxMjE0NjU1WjB8MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EgMjAxMDCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBAKkdDbx3EYo6IOz8E5f1+n9p
// SIG // lGt0VBDVpQoAgoX77XxoSyxfxcPlYcJ2tz5mK1vwFVMn
// SIG // BDEfQRsalR3OCROOfGEwWbEwRA/xYIiEVEMM1024OAiz
// SIG // Qt2TrNZzMFcmgqNFDdDq9UeBzb8kYDJYYEbyWEeGMoQe
// SIG // dGFnkV+BVLHPk0ySwcSmXdFhE24oxhr5hoC732H8RsEn
// SIG // HSRnEnIaIYqvS2SJUGKxXf13Hz3wV3WsvYpCTUBR0Q+c
// SIG // Bj5nf/VmwAOWRH7v0Ev9buWayrGo8noqCjHw2k4GkbaI
// SIG // CDXoeByw6ZnNPOcvRLqn9NxkvaQBwSAJk3jN/LzAyURd
// SIG // XhacAQVPIk0CAwEAAaOCAeYwggHiMBAGCSsGAQQBgjcV
// SIG // AQQDAgEAMB0GA1UdDgQWBBTVYzpcijGQ80N7fEYbxTNo
// SIG // WoVtVTAZBgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTAL
// SIG // BgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNV
// SIG // HSMEGDAWgBTV9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNV
// SIG // HR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29m
// SIG // dC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJB
// SIG // dXRfMjAxMC0wNi0yMy5jcmwwWgYIKwYBBQUHAQEETjBM
// SIG // MEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29m
// SIG // dC5jb20vcGtpL2NlcnRzL01pY1Jvb0NlckF1dF8yMDEw
// SIG // LTA2LTIzLmNydDCBoAYDVR0gAQH/BIGVMIGSMIGPBgkr
// SIG // BgEEAYI3LgMwgYEwPQYIKwYBBQUHAgEWMWh0dHA6Ly93
// SIG // d3cubWljcm9zb2Z0LmNvbS9QS0kvZG9jcy9DUFMvZGVm
// SIG // YXVsdC5odG0wQAYIKwYBBQUHAgIwNB4yIB0ATABlAGcA
// SIG // YQBsAF8AUABvAGwAaQBjAHkAXwBTAHQAYQB0AGUAbQBl
// SIG // AG4AdAAuIB0wDQYJKoZIhvcNAQELBQADggIBAAfmiFEN
// SIG // 4sbgmD+BcQM9naOhIW+z66bM9TG+zwXiqf76V20ZMLPC
// SIG // xWbJat/15/B4vceoniXj+bzta1RXCCtRgkQS+7lTjMz0
// SIG // YBKKdsxAQEGb3FwX/1z5Xhc1mCRWS3TvQhDIr79/xn/y
// SIG // N31aPxzymXlKkVIArzgPF/UveYFl2am1a+THzvbKegBv
// SIG // SzBEJCI8z+0DpZaPWSm8tv0E4XCfMkon/VWvL/625Y4z
// SIG // u2JfmttXQOnxzplmkIz/amJ/3cVKC5Em4jnsGUpxY517
// SIG // IW3DnKOiPPp/fZZqkHimbdLhnPkd/DjYlPTGpQqWhqS9
// SIG // nhquBEKDuLWAmyI4ILUl5WTs9/S/fmNZJQ96LjlXdqJx
// SIG // qgaKD4kWumGnEcua2A5HmoDF0M2n0O99g/DhO3EJ3110
// SIG // mCIIYdqwUB5vvfHhAN/nMQekkzr3ZUd46PioSKv33nJ+
// SIG // YWtvd6mBy6cJrDm77MbL2IK0cs0d9LiFAR6A+xuJKlQ5
// SIG // slvayA1VmXqHczsI5pgt6o3gMy4SKfXAL1QnIffIrE7a
// SIG // KLixqduWsqdCosnPGUFN4Ib5KpqjEWYw07t0MkvfY3v1
// SIG // mYovG8chr1m1rtxEPJdQcdeh0sVV42neV8HR3jDA/czm
// SIG // TfsNv11P6Z0eGTgvvM9YBS7vDaBQNdrvCScc1bN+NR4I
// SIG // uto229Nfj950iEkSMIIE2jCCA8KgAwIBAgITMwAAALM5
// SIG // u9QSkxWp/gAAAAAAszANBgkqhkiG9w0BAQsFADB8MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3Nv
// SIG // ZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDAeFw0xNjA5MDcx
// SIG // NzU2NThaFw0xODA5MDcxNzU2NThaMIGzMQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQL
// SIG // Ex5uQ2lwaGVyIERTRSBFU046NTg0Ny1GNzYxLTRGNzAx
// SIG // JTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNl
// SIG // cnZpY2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
// SIG // AoIBAQCeNnl43rgvzB1J/X4pIlia9mJae8s5Xb3pJWhw
// SIG // JnfLKI9cbzWOq2jXFKmAeAIParLBEYtfZKdrO0QS95eK
// SIG // loQ936p/YWmiiAbOCfSJ5oZmQYSUM8HWIvNUWADaPV7+
// SIG // sKOJpmfsjT1u0yyBf2iL3eVITEPJDm4bfg0CxroFalsC
// SIG // 1A57Kw3zqleTnBJD8QXyWC2O+NUGTE3GyytRvMlkhPD2
// SIG // lWqVsDNYU9QObnUVIr64s81gWwQNCV6YXQALCwBxcnem
// SIG // EeIy0NO23apVBYPGh0F8PhrqIhQQHOjO8JKuy/uMd6Hr
// SIG // xMfe/fHwPBAxpvB9EshmWpWxIybLNfY0GEupIrm1AgMB
// SIG // AAGjggEbMIIBFzAdBgNVHQ4EFgQU013t1ltKqWi+VWZk
// SIG // SYdz6xfwInAwHwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xG
// SIG // G8UzaFqFbVUwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvTWljVGltU3RhUENBXzIwMTAtMDctMDEuY3JsMFoG
// SIG // CCsGAQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNU
// SIG // aW1TdGFQQ0FfMjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/
// SIG // BAIwADATBgNVHSUEDDAKBggrBgEFBQcDCDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEAIld7o1TvUu0RDKAzReQ2fRhybhCz
// SIG // AM9ldRn29YKLG6rlSUxBXHv/QDtoEWuWk1QFcOFsygBj
// SIG // cDhrMszMmyPKiN8jOyRwQ5NZ4u35qVVvp8MTIMUOQTEc
// SIG // CaYV3UZbQumFGcF1s1aZ/HCJXqvbrsqSCC+hG08CAm44
// SIG // b7bg82lQ354sybzHJSxp2bUmr8Qw7qSziMFrtuyHEu3k
// SIG // FHICxGNiwQDnypy6E82eeUO4pqEhe4tepRb61VxSjitj
// SIG // INUbIuBCYVVZ8JDVy3O1ugd6d2ltmNc3mWtZ227e76hg
// SIG // tDTPbdJmVFMMiprgIhCMwMMwmd3kOTLki5jaKjYg+UwZ
// SIG // Zs8py6GCA3kwggJhAgEBMIHjoYG5pIG2MIGzMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYD
// SIG // VQQLEx5uQ2lwaGVyIERTRSBFU046NTg0Ny1GNzYxLTRG
// SIG // NzAxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1w
// SIG // IFNlcnZpY2WiJQoBATAJBgUrDgMCGgUAAxUAvvnB9NoP
// SIG // FT/wkAMDvnilmtqK3LmggcIwgb+kgbwwgbkxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNV
// SIG // BAsTHm5DaXBoZXIgTlRTIEVTTjo0REU5LTBDNUUtM0Uw
// SIG // OTErMCkGA1UEAxMiTWljcm9zb2Z0IFRpbWUgU291cmNl
// SIG // IE1hc3RlciBDbG9jazANBgkqhkiG9w0BAQUFAAIFANxF
// SIG // zE4wIhgPMjAxNzAyMDgxNjU2NDZaGA8yMDE3MDIwOTE2
// SIG // NTY0NlowdzA9BgorBgEEAYRZCgQBMS8wLTAKAgUA3EXM
// SIG // TgIBADAKAgEAAgISXwIB/zAHAgEAAgIZrjAKAgUA3Ecd
// SIG // zgIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZ
// SIG // CgMBoAowCAIBAAIDFuNgoQowCAIBAAIDB6EgMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQBd5UN2ai7OYgMuoSGOLcGxsS9r
// SIG // vJWscGl9xghl4Gfgait9gruC8hVdm2M+MF2vVDazVHm+
// SIG // V8GHpQ+gOciqv35AaZKyD6GwfrSMkpE29p+7q0rST1f5
// SIG // cYQVy5r8iwB7yD3CYcm2BHS3dLibbn1WJGVT8zx2HW++
// SIG // uhAy+zEROWF8aPHISs7OnaFrUR/TIuHXHs1N35fHfoXK
// SIG // p/I/L7nRpley7j2yTfSKbvv2NwWprUYlvRwoxdD/OTIF
// SIG // 2gHu8JsToWXdW6yuVWK4x7Jj1D2+gKTynjxZgwsghnPa
// SIG // 7tf89NPJTtS6P4iac+5QiC9rNUXwqPUjku+c14H8NWmR
// SIG // 573uz8hFMYIC9TCCAvECAQEwgZMwfDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUt
// SIG // U3RhbXAgUENBIDIwMTACEzMAAACzObvUEpMVqf4AAAAA
// SIG // ALMwDQYJYIZIAWUDBAIBBQCgggEyMBoGCSqGSIb3DQEJ
// SIG // AzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQg
// SIG // hNmBGSFUZQzw7PyjsNYnUHA7+J9RHBUFpcrcu8WkW4ow
// SIG // geIGCyqGSIb3DQEJEAIMMYHSMIHPMIHMMIGxBBS++cH0
// SIG // 2g8VP/CQAwO+eKWa2orcuTCBmDCBgKR+MHwxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBU
// SIG // aW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAszm71BKTFan+
// SIG // AAAAAACzMBYEFLWNneMdg42AdweVFAhg0YUXXOauMA0G
// SIG // CSqGSIb3DQEBCwUABIIBABlee3/9cLkKZ5RwEBNNQ1Ow
// SIG // Gaejv4aIQH45QTz5pEuug6EQWGaOT7C56uwBANrL5JNz
// SIG // FQYxYgzFu14j2zx+Q6JTigXwugzViACPiljXS38fxSr1
// SIG // qIxmFNvJHsTZRi/IYcVgG+b5COMHkW7uuqarRqE5hTU1
// SIG // TE5ZQdOc+e1wuCHQ9LbOXTnWoWN8da8KnE8IjoAqXGjA
// SIG // 185PpYMZGJGgAJZw9x8jQsD0SAY4l5E2BZL4BeoVB5QE
// SIG // w4lqTw5ZufMcZpNeKRYzw4/eCSwbKwh5nksUvnu/8Crq
// SIG // 4EFtAiyPUrFhB6Mmh7TVXer7Se6Vs0/NhXvwaJ2WgvTI
// SIG // XYtty/B37+Y=
// SIG // End signature block
